<?php

namespace App\Filters;

use App\Filters\ApiFilter;

class InvoiceFilter extends ApiFilter {
  protected $safeParams = [
    'id' => ['eq'],
    'name' => ['like'],
    'type' => ['eq', 'ne'],
    'client' => ['eq'],
    'amount' => ['ltq'],
    'date' => ['date_eq'],
    'entrega' =>['eq'],
    'pedido' => ['eq','ne']
  ];
  protected $columnMap = [
    'id' => 'id',
    'name' => 'nombreComercial',
    'type' => 'type',
    'client' => 'client_id',
    'amount' => 'amount',
    'date' => 'billed_at',
    'entrega' => 'entregado',
    'pedido' => 'tipo_pedido'
  ];

}
