<?php
namespace App\Filters;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class ApiFilter {
    protected $safeParams = [];
    protected $columnMap = [];
    protected $operatorMap = [
        'eq' => '=',
        'gt' => '>',
        'lt' => '<',
        'lte' => '<=',
        'gte' => '>=',
        'like' => 'LIKE',
        'ne' => '!=',
        'ltq' => 'total',
        'sch' => 'search',
        'date_eq' => 'DATE'
    ];

    public function transform(Request $request)
    {
        $eloQuery = [];
        foreach ($this->safeParams as $param => $operators) {
            $query = $request->query($param);
            if (!isset($query)) {
                continue;
            }
            $column = $this->columnMap[$param] ?? $param;
            foreach ($operators as $operator) {
                if (isset($query[$operator])) {
                    if ($operator === 'like') {
                        $eloQuery[] = [$column, $this->operatorMap[$operator], '%' . $query[$operator] . '%'];
                    } elseif ($operator === 'ltq') { // Manejar "menor que"
                        $eloQuery[] = [$column, $this->operatorMap[$operator], $query[$operator]];
                    } elseif ($operator === 'sch') {
                        $tableAndColumn = $this->columnMap[$param];
                        if ($tableAndColumn) {
                            list($relation, $column) = explode('.', $tableAndColumn);
                            $queryValue = $query[$operator];
                            $eloQuery[] = function($q) use ($relation, $column, $queryValue) {
                                $q->whereHas($relation, function($q) use ($column, $queryValue) {
                                    $q->where($column, '=', $queryValue);
                                });
                            };
                        }
                    } elseif ($operator === 'date_eq') { // Manejar "igual a" para fechas
                        $date = Carbon::createFromFormat('Y-m-d', $query[$operator])->format('Y-m-d');
                        $eloQuery[] = [DB::raw("DATE($column)"), '=', $date];
                    } else {
                        $eloQuery[] = [$column, $this->operatorMap[$operator], $query[$operator]];
                    }
                }
            }
        }
        return $eloQuery;
    }
}
